# N-PORT Filings Data

This dataset contains the data derived from the universe of N-PORT filings from the SEC EDGAR database as constructed for Barth, Kahn, Monin and Sokolinskiy (2024) "Reaching for Duration and Leverage in the Treasury Market." The dataset will be updated quarterly. Details of this data and variable construction can be found in this paper. Please contact R.Jay Kahn (jay@j-kahn.com) with any additional questions or comments.

Citations of this data should be to:

    Daniel Barth, R. Jay Kahn, Phillip J. Monin and Oleg Sokolinskiy, 2024. "Reaching for Duration and Leverage in the Treasury Market," Finance and Economics Discussion Series 2024-039, Board of Governors of the Federal Reserve System (U.S.).

## Data fields
fname: source file name
seriesid: SEC series id (blank when not assigned)
serieslei: LEI for series
seriesname: Name of series
regname: Registrant name
regfilenumber: Registrant file number
regcik: Registrant CIK
reglei: Registrant LEI
new_seriesid: Assigned series id (filled with custom id when seriesid not assigned)
reppdend: Dare of fiscal year-end
reppddate: As-of date for report
next_quarter: Next quarter from reppddate
is_last_filing: 1 if last filing currently available for reppddate, 0 otherwise
is_last_report: 1 if last reportdt currently available for quarter.
totassets: Total assets
totliabs: Total liabilities
netassets: Net assets
cshnotrptdincord: Cash and cash equivalents not present in the "inv" series below
wdmat: Weighted average days to maturity of debt securities
inv_abs_apcp_long: Share of assets in long investments in asset-backed commercial paper
inv_abs_cbdo_long: Share of assets in long investments in collateralized bond obligations
inv_abs_mbs_long: Share of assets in long investments in mortgage-backed securities
inv_abs_mbs_agy_long: Share of assets in long investments in agency mortgage-backed securities
inv_abs_mbs_plb_long: Share of assets in long investments in private-label mortgage-backed securities
inv_abs_o_long: Share of assets in long investments in other asset-backed securities
inv_agy_long: Share of assets in long investments in non-MBS agency securities
inv_cor_long: Share of assets in long investments in corporate securities
inv_csh_long: Share of assets in long investments in cash and cash equivalents
inv_dir_long: Share of assets in long investments in derivatives
inv_eqt_long: Share of assets in long investments in equities
inv_for_long: Share of assets in long investments in foreign corporate debt securities
inv_lon_long: Share of assets in long investments in loans
inv_mun_long: Share of assets in long investments in municipal securities
inv_oth_long: Share of assets in long investments in other securities
inv_pfs_long: Share of assets in long investments in private funds
inv_rei_long: Share of assets in long investments in real estate investments
inv_rep_long: Share of assets in long investments in repurchase agreements
inv_ric_long: Share of assets in long investments in registered investment companies
inv_sov_long: Share of assets in long investments in non-US sovereign debt securities
inv_ust_long: Share of assets in long investments in US Treasury securities
inv_abs_apcp_short: Share of assets in short investments in asset-backed commercial paper
inv_abs_cbdo_short: Share of assets in short investments in collateralized bond obligations
inv_abs_mbs_short: Share of assets in short investments in mortgage-backed securities
inv_abs_mbs_agy_short: Share of assets in short investments in agency mortgage-backed securities
inv_abs_mbs_plb_short: Share of assets in short investments in private-label mortgage-backed securities
inv_abs_o_short: Share of assets in short investments in other asset-backed securities
inv_agy_short: Share of assets in short investments in non-MBS agency securities
inv_cor_short: Share of assets in short investments in corporate securities
inv_csh_short: Share of assets in short investments in cash and cash equivalents
inv_dir_short: Share of assets in short investments in derivatives
inv_eqt_short: Share of assets in short investments in equities
inv_for_short: Share of assets in short investments in foreign corporate debt securities
inv_lon_short: Share of assets in short investments in loans
inv_mun_short: Share of assets in short investments in municipal securities
inv_oth_short: Share of assets in short investments in other securities
inv_pfs_short: Share of assets in short investments in private funds
inv_rei_short: Share of assets in short investments in real estate investments
inv_rep_short: Share of assets in short investments in repurchase agreements
inv_ric_short: Share of assets in short investments in registered investment companies
inv_sov_short: Share of assets in short investments in non-US sovereign debt securities
inv_ust_short: Share of assets in short investments in US Treasury securities
cd_for_dm_long: Share of assets in long investments in foreign corporate debt from developed marakets
cd_sov_dm_long: Share of assets in long investments in non-US sovereign debt from developed markets
cd_for_em_long: Share of assets in long investments in foreign corporate debt from emerging markets 
cd_sov_em_long: Share of assets in long investments in non-US sovereign debt from emerging markets
cd_for_oth_long: Share of assets in long investments in foreign corporate debt from other markets
cd_sov_oth_long: Share of assets in long investments in non-US sovereign debt from other markets
cd_for_dm_short: Share of assets in short investments in foreign corporate debt from developed marakets
cd_sov_dm_short: Share of assets in short investments in non-US sovereign debt from developed markets
cd_for_em_short: Share of assets in short investments in foreign corporate debt from emerging markets
cd_sov_em_short: Share of assets in short investments in non-US sovereign debt from emerging markets
cd_for_oth_short: Share of assets in short investments in foreign corporate debt from other markets
cd_sov_oth_short: Share of assets in short investments in non-US sovereign debt from other markets
cd_dm_long: Share of assets in long investments in debt from developed markets
cd_em_long: Share of assets in long investments in debt from emerging markets   
cd_oth_long: Share of assets in long investments in debt from other markets
cd_us_long: Share of assets in long investments in US debt
cd_dm_short: Share of assets in short investments in debt from developed markets
cd_em_short: Share of assets in short investments in debt from emerging markets
cd_oth_short: Share of assets in short investments in debt from other markets
cd_us_short: Share of assets in short investments in US debt
tfut_long_10y_notionalamt: Notional amount of long 10-year Treasury futures
tfut_long_10yultra_notionalamt: Notional amount of long ultra 10-year Treasury futures
tfut_long_2y_notionalamt: Notional amount of long 2-year Treasury futures
tfut_long_30y_notionalamt: Notional amount of long 30-year Treasury futures
tfut_long_30yultra_notionalamt: Notional amount of long ultra 30-year Treasury futures
tfut_long_3y_notionalamt: Notional amount of long 3-year Treasury futures
tfut_long_5y_notionalamt: Notional amount of long 5-year Treasury futures
tfut_short_10y_notionalamt: Notional amount of short 10-year Treasury futures
tfut_short_10yultra_notionalamt: Notional amount of short ultra 10-year Treasury futures
tfut_short_2y_notionalamt: Notional amount of short 2-year Treasury futures
tfut_short_30y_notionalamt: Notional amount of short 30-year Treasury futures
tfut_short_30yultra_notionalamt: Notional amount of short ultra 30-year Treasury futures
tfut_short_3y_notionalamt: Notional amount of short 3-year Treasury futures
tfut_short_5y_notionalamt: Notional amount of short 5-year Treasury futures
tfut_long_tot_notionalamt: Total notional amount of long Treasury futures
tfut_short_tot_notionalamt: Total notional amount of short Treasury futures
amnt_futrderiv_comm: Notional amount of commodity futures
amnt_futrderiv_credit: Notional amount of credit futures
amnt_futrderiv_equity: Notional amount of equity futures
amnt_futrderiv_fx: Notional amount of FX futures
amnt_futrderiv_ird: Notional amount of interest rate futures
amnt_futrderiv_other: Notional amount of other futures
amnt_fwdderiv_comm: Notional amount of commodity forwards
amnt_fwdderiv_credit: Notional amount of credit forwards
amnt_fwdderiv_equity: Notional amount of equity forwards
amnt_fwdderiv_fx: Notional amount of FX forwards
amnt_fwdderiv_ird: Notional amount of interest rate forwards
amnt_fwdderiv_other: Notional amount of other forwards
amnt_swapderiv_comm: Notional amount of commodity swaps
amnt_swapderiv_credit: Notional amount of credit swaps
amnt_swapderiv_equity: Notional amount of equity swaps
amnt_swapderiv_fx: Notional amount of FX swaps
amnt_swapderiv_ird: Notional amount of interest rate swaps
amnt_swapderiv_other: Notional amount of other swaps
pctval2_1m: Share of total assets in debt maturing in 1 month
pctval2_3m: Share of total assets in debt maturing between 1 and 3 months
pctval2_1: Share of total assets in debt maturing between 3 and 12 months
pctval2_1-5: Share of total assets in debt maturing between 1 and 5 years
pctval2_5-10: Share of total assets in debt maturing between 5 and 10 years
pctval2_10-20: Share of total assets in debt maturing between 10 and 20 years
pctval2_20-30: Share of total assets in debt maturing between 20 and 30 years
pctval_1m_abs: Share of total assets in asset-backed securities maturing in 1 month
pctval_1m_cor: Share of total assets in corporate debt maturing in 1 month
pctval_1m_csh: Share of total assets in cash and cash-equivalents maturing in 1 month
pctval_1m_mun: Share of total assets in municipal debt maturing in 1 month
pctval_1m_oth: Share of total assets in other debt maturing in 1 month
pctval_1m_rep: Share of total assets in repurchase agreements maturing in 1 month
pctval_1m_sov: Share of total assets in sovereign debt maturing in 1 month
pctval_1m_ust: Share of total assets in US Treasury debt maturing in 1 month
pctval_3m_abs: Share of total assets in asset-backed securities maturing between 1 and 3 months
pctval_3m_cor: Share of total assets in corporate debt maturing between 1 and 3 months
pctval_3m_csh: Share of total assets in cash and cash-equivalents maturing between 1 and 3 months
pctval_3m_mun: Share of total assets in municipal debt maturing between 1 and 3 months
pctval_3m_oth: Share of total assets in other debt maturing between 1 and 3 months
pctval_3m_rep: Share of total assets in repurchase agreements maturing between 1 and 3 months
pctval_3m_sov: Share of total assets in sovereign debt maturing between 1 and 3 months
pctval_3m_ust: Share of total assets in US Treasury debt maturing between 1 and 3 months
pctval_1_abs: Share of total assets in asset-backed securities maturing between 3 and 12 months
pctval_1_cor: Share of total assets in corporate debt maturing between 3 and 12 months
pctval_1_csh: Share of total assets in cash and cash-equivalents maturing between 3 and 12 months
pctval_1_mun: Share of total assets in municipal debt maturing between 3 and 12 months
pctval_1_oth: Share of total assets in other debt maturing between 3 and 12 months
pctval_1_rep: Share of total assets in repurchase agreements maturing between 3 and 12 months
pctval_1_sov: Share of total assets in sovereign debt maturing between 3 and 12 months
pctval_1_ust: Share of total assets in US Treasury debt maturing between 3 and 12 months
pctval_1-5_abs: Share of total assets in asset-backed securities maturing between 1 and 5 years
pctval_1-5_cor: Share of total assets in corporate debt maturing between 1 and 5 years
pctval_1-5_csh: Share of total assets in cash and cash-equivalents maturing between 1 and 5 years
pctval_1-5_mun: Share of total assets in municipal debt maturing between 1 and 5 years
pctval_1-5_oth: Share of total assets in other debt maturing between 1 and 5 years
pctval_1-5_rep: Share of total assets in repurchase agreements maturing between 1 and 5 years
pctval_1-5_sov: Share of total assets in sovereign debt maturing between 1 and 5 years
pctval_1-5_ust: Share of total assets in US Treasury debt maturing between 1 and 5 years
pctval_5-10_abs: Share of total assets in asset-backed securities maturing between 5 and 10 years
pctval_5-10_cor: Share of total assets in corporate debt maturing between 5 and 10 years
pctval_5-10_csh: Share of total assets in cash and cash-equivalents maturing between 5 and 10 years
pctval_5-10_mun: Share of total assets in municipal debt maturing between 5 and 10 years
pctval_5-10_oth: Share of total assets in other debt maturing between 5 and 10 years
pctval_5-10_rep: Share of total assets in repurchase agreements maturing between 5 and 10 years
pctval_5-10_sov: Share of total assets in sovereign debt maturing between 5 and 10 years
pctval_5-10_ust: Share of total assets in US Treasury debt maturing between 5 and 10 years
pctval_10-20_abs: Share of total assets in asset-backed securities maturing between 10 and 20 years
pctval_10-20_cor: Share of total assets in corporate debt maturing between 10 and 20 years
pctval_10-20_csh: Share of total assets in cash and cash-equivalents maturing between 10 and 20 years
pctval_10-20_mun: Share of total assets in municipal debt maturing between 10 and 20 years
pctval_10-20_oth: Share of total assets in other debt maturing between 10 and 20 years
pctval_10-20_rep: Share of total assets in repurchase agreements maturing between 10 and 20 years
pctval_10-20_sov: Share of total assets in sovereign debt maturing between 10 and 20 years
pctval_10-20_ust: Share of total assets in US Treasury debt maturing between 10 and 20 years
pctval_20-30_abs: Share of total assets in asset-backed securities maturing between 20 and 30 years
pctval_20-30_cor: Share of total assets in corporate debt maturing between 20 and 30 years
pctval_20-30_csh: Share of total assets in cash and cash-equivalents maturing between 20 and 30 years
pctval_20-30_mun: Share of total assets in municipal debt maturing between 20 and 30 years
pctval_20-30_oth: Share of total assets in other debt maturing between 20 and 30 years
pctval_20-30_rep: Share of total assets in repurchase agreements maturing between 20 and 30 years
pctval_20-30_sov: Share of total assets in sovereign debt maturing between 20 and 30 years
pctval_20-30_ust: Share of total assets in US Treasury debt maturing between 20 and 30 years
pctval_usd: Share of total assets in US dollar debt
pctval_eur: Share of total assets in Euro debt
pctval_gbp: Share of total assets in British pound debt
pctval_cny: Share of total assets in Chinese yuan debt
pctval_jpy: Share of total assets in Japanese yen debt
sales_1: Sales in month 1
sales_2: Sales in month 2
sales_3: Sales in month 3
redemption_1: Redemptions in month 1
redemption_2: Redemptions in month 2
redemption_3: Redemptions in month 3
reinvestment_1: Reinvestments in month 1
reinvestment_2: Reinvestments in month 2
reinvestment_3: Reinvestments in month 3